// *********************************************************************
//    Copyright (c) 1989-2002  Warren Furlow
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// *********************************************************************

// *********************************************************************
// WFile.h: header file
// *********************************************************************

class WFile
  {
  public:
  WFile(int BufferSizeIn=8000);
  ~WFile();
  void Rewind();
  flag Open(const char *szFileName);
  void Close();
  char *GetLine();
  char *GetToken();
  char *GetString(char chDelimiter);
  void SkipWhiteSpace();
  void SkipToken();
  flag EOLN()  {  return(pchCurrent>=pszLineEnd);  }
  char CurrentChar()  {  return(*pchCurrent); }
  LPCTSTR CurrentLine()  {  return(strCurrentLine); }
  HANDLE FileHandle()  {  return(hFileHandle);  }
  int LineNumber()  {  return(nLineNumber);  }
  int LineLength()  {  return(strCurrentLine.GetLength());  }
  
  private:
  CString strCurrentLine; // copy of the current line
  char *pBuffer;          // buffer
  char *pDataEnd;         // end of data in buffer
  int nBufferSize;        // buffer allocated size
  HANDLE hFileHandle;     // low level file handle
  char *pchCurrent;       // pointer to current char
  char *pszLineStart;     // pointer to current line start
  char *pszLineEnd;       // pointer to current line end
  int nLineNumber;        // current line number

  ulong nBytesRead;       // number of bytes last read
  ulong nFileSize;        // number of bytes in file
  };
