#ifndef __UDP_H__
#define __UDP_H__

#if _MSC_VER >= 1000
#pragma once
#endif

class Udp
{
public:
	static bool IsComPort(LPCTSTR lpszComPort);
	VOID SetParam(LPCSTR lpszAddr, DWORD dwPort);
	VOID Reset();
	bool SendByte(BYTE byData);

	static Udp *getInstance()
	{
		static Cleaner cleaner;

		if (pInstance_== NULL)
			pInstance_ = new Udp;
		return pInstance_;
	};

	static void deleteInstance();

protected:
	// no one can inherit from me
	Udp();
	~Udp();

	Udp& operator=(const Udp&);

	#if _MSC_VER >= 1900 // VS2015 and later
		Udp(const Udp&) = delete;			// no one can copy me
	#else
		Udp(const Udp&) {};					// no one can copy me
	#endif

	static Udp *pInstance_;

private:
	CString m_strAddr;						// address printer server or COM port

	SOCKADDR_IN m_sServer;					// UDP server address
	DCB m_dcb;								// DCB structure with baud rate

	bool (Udp::*m_fpSendByte)(BYTE byData);	// function pointer to send routine
	bool SendByteUdp(BYTE byData);
	bool SendByteRS232(BYTE byData);

	// cleaner class preventing memory leak
	class Cleaner
	{
	public:
		~Cleaner()
		{
			deleteInstance();
		}
	};
};
#endif // __UDP_H__
