#ifndef __TCPIP_H__
#define __TCPIP_H__

#if _MSC_VER >= 1000
#pragma once
#endif

#include "HP41HpilIf.h"

class TcpIp
{
public:
	TcpIp(HpilIf *pHpil,LPCTSTR lpszAddrOut,WORD wPortOut,WORD wPortIn);
	~TcpIp();

	VOID SetConnectTimeout(DWORD dwConnectTimeout) { m_dwConnectTimeout = dwConnectTimeout; }
	bool TcpCreateSvr();
	VOID TcpCloseSvr();
	bool TcpSendFrame(WORD wFrame);

private:
	HpilIf *m_pHpil;						// tcp/ip address of target server

	const CString m_strAddrOut;				// tcp/ip address of target server
	const WORD    m_wPortOut;				// tcp/ip port of target server
	const WORD    m_wPortIn;				// tcp/ip port of my receive server

	DWORD  m_dwConnectTimeout;				// non-blocked IO connect timeout in us,  0xFFFFFFFF is blocked IO connect

	bool   m_bRunning;
	HANDLE m_hWorkerThread;

	#define NFDS 2
	SOCKET m_sockfds[NFDS];
	INT    m_nNumSocks;
	SOCKET m_cfd;
	SOCKET m_sClient;

	__inline VOID SetNonBlockedIO(unsigned long flag) const;
	static UINT __stdcall ThreadTcpIpServer(LPVOID pParam);

	bool StartServer();
	VOID StopServer();
};
#endif // __TCPIP_H__
