#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

class CMcodeDlg;
class CRamViewDlg;
class CBreakPointsDlg;
class CBackDlg;

class CMainWindow : public CFrameWnd
  {
public:
  CMainWindow();

  //{{AFX_MSG( CMainWindow )
  afx_msg void OnFileNew();
  afx_msg void OnFileOpen();
  afx_msg void OnFileEdit();
  afx_msg void OnFileExit();
  afx_msg void OnFileSave();
  afx_msg void OnFileSaveas();
  afx_msg void OnAppAbout();
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  afx_msg void OnDestroy();
  afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
  afx_msg void OnEndSession(BOOL bEnding);
  afx_msg void OnPaint();
  afx_msg BOOL OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct);
  afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
  afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  afx_msg void OnNcMouseMove(UINT nFlags, CPoint point);
  afx_msg LRESULT OnNcHitTest(CPoint point);
  afx_msg void OnOptionsTiny();
  afx_msg void OnOptionsSmall();
  afx_msg void OnOptionsMedium();
  afx_msg void OnOptionsLarge();
  afx_msg void OnOptionsXLarge();
  afx_msg void OnBack();
  afx_msg void OnOptionsSettings();
  afx_msg void OnHelpUsage();
  afx_msg void OnHelpIndex();
  afx_msg void OnFilePut();
  afx_msg void OnFileGet();
  afx_msg void OnFileCopy();
  afx_msg BOOL OnQueryNewPalette();
  afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
  afx_msg void OnOptionsJumpToForeground();
  afx_msg void OnOptionsAlwaysontop();
  afx_msg void OnOptionsShowTitle();
  afx_msg void OnOptionsShowMenu();
  afx_msg void OnOptionsReset();
  afx_msg void OnMcodeTrace();
  afx_msg void OnMcodeConsole();
  afx_msg void OnOptionsRamView();
  afx_msg void OnOptionsBreakpoints();
  afx_msg void OnOptionsTraceSettings();
	afx_msg void OnFilePageview();
	//}}AFX_MSG
  bool FileOpen(LPCTSTR lpszFileName);
  UINT FileSave(bool bAutoSave);
  static const CString getPath(LPCTSTR szFullFilename);
  static void ForceToForeground(CWnd *pWnd);
  void CloseConsole();
  void OpenConsole();
  void CloseRamView();
  void UpdateRamView();
  void OpenBreakpoints();
  void CloseBreakpoints();
  virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

  HP41 *GetHP41() const { return pHP41; }

  flag getJumpToForeground() { return fJumpToForeground; }

DECLARE_MESSAGE_MAP()

protected:
  HP41 *pHP41;
  CMcodeDlg *dlgMcode;               // pointer to mcode dialog class instance
  CRamViewDlg *dlgRamView;           // pointer to ramview dialog class instance
  CBreakPointsDlg *dlgBreakPoints;   // pointer to breakpoints dialog class instance
  CBackDlg *dlgBack;                 // pointer to back dialog class instance
  CMenu MainMenu;                    // the menu bar for the main window
  CMenu PopupMenu;                   // the pop up menu for right click
  flag fEndSession;                  // session ending
  flag fAutoSave;                    // autosave on exit
  flag fAlwaysOnTop;                 // window is always on top
  flag fTrueType;                    // true type font is used
  flag fShowTitle;                   // main window title bar is visible
  flag fShowMenu;                    // main window menu bar is visible
  flag fClassicCursor;               // using arrow cursor over window and buttons
  flag fShowConsole;                 // mcode console is visible
  flag fShowRamView;                 // RAM viewer is visible
  flag fRamViewLockWinUpdate;        // use LockWindowsUpdate for Win10 or greater
  flag fJumpToForeground;            // any mouseover will set this as the foreground window
  flag fShowBreakpoints;             // breakpoints dialog is visible
  byte WinKeyDown;                   // ==0 if no key, == VK if key pressed (by PC keyboard)
  byte WinMouseKeyDown;              // ==0 if no key, == VK if key pressed (by mouse)
  int ProcInterval,ProcCycles;       // processor speed
  int TurboFactor;                   // turbo mode acceleration factor

  void UpdateMenus(int eKeyboard=HP41::eKeyboardNone);
  void SetMenuChecks(CMenu *pMenu,int eKeyboard=HP41::eKeyboardNone);
  void SetTitle();

private:
  BOOL m_bIsWindows8orLater;

  HCURSOR hCursorArrow;
  HCURSOR hCursorHand;

  CString strLastFolderLod;          // last folder LOD file loaded
  CString strLastFolderRaw;          // last folder RAW file loaded
  bool bSessionNameValid;            // session name is valid

  void NonModalAlwaysOnTop(flag fEnable);
  static void SetWindowLocation(CWnd *pWnd,INT nPosX,INT nPosY,INT nWidth=0,INT nHeight=0);
  };

#endif // __MAINWINDOW_H__
