// *********************************************************************
//    Copyright (c) 2002 Frank Bauernoeppel
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// *********************************************************************

// *********************************************************************
// HP41Sound.h : implementation file
// *********************************************************************

#include <mmsystem.h>

// sound volume
#define MIN_VOLUME	0
#define MAX_VOLUME	0x7F

class HP41Sound {
public:
	 HP41Sound();
	~HP41Sound();
	int Open();																	// open a sound output channel
	int Open( int valSilence );									// same as above, but a silence value is set, 
																							// playback will only start after differnt values are Put
	int Close();																// close the sound output channel
	int Put(int val);														// put next sample to output queue
	int Flush();																// flush output queue
	void SetDuration(DWORD dwVal);							// simulated proc speed in millisec
	flag IsAvailable(void);											// returns 1 if wave device is available
	void SetVolume( byte byVolumeIn );						// 16-bit volume parameter (if supported by hardware): 0xFF full - 0 quiet
	byte GetVolume() const { return byVolume; };	// get current volume 

	// implementation
protected:

	CRITICAL_SECTION cs;

	WAVEFORMATEX wfmt;
	HWAVEOUT hWaveOut;

	LPWAVEHDR lpWaveHdr;	// pointer to wave packet header

	DWORD dwSize;					// packet fill (in bytes)

	flag fSilent;					// current buffer contains only the same value m_nVal
	int nVal;							// the value that we are looking for
	DWORD dwSilent;				// number of silent buffers (buffers containing m_nVal only)

	DWORD dwDuration;			// simulated proc speed in millisec

	byte byVolume;				// current volume setting

private:
	HANDLE hThreadWave;			// thread handle of sound message handler
	DWORD  dwThreadWaveId;	// thread id of sound message handler

	static UINT __stdcall SoundWndProc(LPVOID pParam);
	bool CreateWaveThread();
	void DestroyWaveThread();
};

flag PlayWaveResource(WORD wResourceId);

extern HP41Sound WaveSound;

