#pragma once
#include "MaskEdit.h"

/***********************/
// CAboutDlg dialog used for App About
/***********************/
class CAboutDlg : public CDialog
  {
  public:
  CAboutDlg();

  //{{AFX_DATA(CAboutDlg)
  enum { IDD = IDD_ABOUTBOX };
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CAboutDlg)
  protected:
  //}}AFX_VIRTUAL

  protected:
  //{{AFX_MSG(CAboutDlg)
  afx_msg void OnLicense();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
  };


/***********************/
// CSettingsDlg dialog used for Options Settings
/***********************/
class CSettingsDlg : public CDialog
  {
  public:
  CSettingsDlg();
  ~CSettingsDlg();
  HP41 *pHP41;
  int Interval;
  int Turbo;
  int Contrast;
  COLORREF FontColor;
  COLORREF BkFontColor;
  flag fAutoSave;
  flag fSpeakerSoundAvail;
  flag fWaveSoundAvail;
  word SoundMode;
  byte WaveVolume;
  flag fTrueType;
  flag fSingle;
  flag fAutoIdy;
  CString strOutAddr;
  word wOutPort;
  word wInPort;

  //{{AFX_DATA(CSettingsDlg)
  enum { IDD = IDD_SETTINGS };
  CSliderCtrl ctlInterval;
  CStatic ctlStaticSpeed;
  CStatic ctlStaticTurbo;
  CSliderCtrl ctlTurbo;
  CStatic ctlSample;
  CStatic ctlStaticRed;
  CStatic ctlStaticLight;
  CStatic ctlStaticGreen;
  CStatic ctlStaticDark;
  CStatic ctlStaticBlue;
  CSliderCtrl ctlRed;
  CSliderCtrl ctlGreen;
  CSliderCtrl ctlBlue;
  CButton ctlColor;
  CStatic ctlStaticContrast;
  CStatic ctlStaticVolume;
  CButton ctlSingle;
  CButton ctlAutoIdy;
  CButton ctlTrueType;
  CButton ctlDefaults;
  CButton ctlAutoSave;
  CButton ctlSoundNone;
  CButton ctlSoundSpeaker;
  CButton ctlSoundWave;
  CSliderCtrl ctlWaveVolume;
  CSliderCtrl ctlContrast;
  CEdit	ctlOutAddr;
  CEdit	ctlOutPort;
  CEdit	ctlInPort;
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CSettingsDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

  protected:
  //{{AFX_MSG(CSettingsDlg)
  virtual void OnOK();
  virtual BOOL OnInitDialog();
  afx_msg void OnDefaults();
  afx_msg void OnSoundWave();
  afx_msg void OnSoundSpeaker();
  afx_msg void OnSoundNone();
  afx_msg void OnTrueType();
  afx_msg void OnCheckColor();
  afx_msg void OnSliderContrast(NMHDR* pNMHDR, LRESULT* pResult);
  afx_msg void OnSliderColor(NMHDR* pNMHDR, LRESULT* pResult);
  afx_msg void OnPaint();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()

private:
  CFont CFontLCD;
  void InvalidateSample();
  };


/***********************/
// CBackDlg dialog used for Backside bitmap
/***********************/
class CBackDlg : public CDialog
  {
  public:
  CBackDlg(CWnd* pParent = NULL);

  private:
  BITMAPINFOHEADER *pBMBack;
  LOGPALETTE *pPalBack;
  BITMAPINFO *pPalIndexBack;

  //{{AFX_DATA(CBackDlg)
  enum { IDD = IDD_BACK };
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CBackDlg)
  protected:
  //}}AFX_VIRTUAL

  protected:
  //{{AFX_MSG(CBackDlg)
  afx_msg void OnPaint();
  virtual BOOL OnInitDialog();
  afx_msg void OnDestroy();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
  };


/***********************/
// CSelectDlg dialog used for user code program selection
/***********************/
class CSelectDlg : public CDialog
  {
  public:
  CSelectDlg();
  std::vector<int> vnProgramSel;
  CPtrArray *pCatArray;

  //{{AFX_DATA(CSelectDlg)
  enum { IDD = IDD_SELECT };
  CListBox ctlProgList;
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CSelectDlg)
  public:
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

  protected:
  //{{AFX_MSG(CSelectDlg)
  afx_msg void OnDblclkProgList();
  virtual void OnOK();
  virtual BOOL OnInitDialog();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
  };


/***********************/
// Mcode dialog
/***********************/
class CMcodeDlg : public CDialog
  {
  public:
  CMcodeDlg(CWnd* pParent = NULL);
  ~CMcodeDlg();
  HP41 *pHP41;
  CFont fontDlg;
  flag fMultiStepping;
  static CMcodeDlg *pThis;         // to give TimerProc a this pointer
  static void CALLBACK StepTimerProc(HWND hwnd,UINT uMsg,UINT_PTR idEvent,DWORD dwTime);
  UINT_PTR CallbackStepTimer;      // ==0 if no timer, non zero if timer is set
  int CharWidth,CharHeight;        // width and height of one char in pixels
  uint Left,Top;

  //{{AFX_DATA(CMcodeDlg)
  enum { IDD = IDD_MCODE };
  CSliderCtrl ctlSpeed;
  CButton ctlMultiStep;
  CButton ctlIndicator;
  CButton ctlSetHP;
  CButton ctlSetZencode;
  CButton ctlSetJDA;
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CMcodeDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

  protected:
  //{{AFX_MSG(CMcodeDlg)
  virtual void OnCancel();
  virtual void OnOK();
  virtual BOOL OnInitDialog();
  afx_msg void OnActivityIndicator();
  afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
  afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
  afx_msg void OnSingleStep();
  afx_msg void OnMultiStep();
  afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
  afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
  afx_msg void OnPaint();
  afx_msg void OnSetHP();
  afx_msg void OnSetZencode();
  afx_msg void OnSetJDA();
  afx_msg void OnClose();
  afx_msg void OnDestroy();
  afx_msg void OnRegA();
  afx_msg void OnRegB();
  afx_msg void OnRegC();
  afx_msg void OnRegM();
  afx_msg void OnRegN();
  afx_msg void OnRegP();
  afx_msg void OnRegQ();
  afx_msg void OnRegPT();
  afx_msg void OnRegG();
  afx_msg void OnRegST();
  afx_msg void OnRegCARRY();
  afx_msg void OnRegHEX();
  afx_msg void OnRegPC();
  afx_msg void OnRegBK();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()

  private:
  int OnReg_(byte *reg, uint reglen,uint base);
  };


/***********************/
// CRamView dialog
/***********************/
class CRamViewDlg : public CDialog
  {
  public:
  CRamViewDlg(CWnd* pParent = NULL);
  ~CRamViewDlg();
  HP41 *pHP41;
  uint Left,Top,Right,Bottom;
  CTreeCtrl m_TreeCtrl;                     // the tree control
  bool m_bWin8;                             // Windows 8 or greater
  flag fRamShowEmptyReg;
  flag fRamShowFlags;
  flag fRamBufferName;

  VOID Clear();
  VOID UpdateRamView(bool bForce = false);

  //{{AFX_DATA(CRamViewDlg)
  enum { IDD = IDD_RAMVIEW };
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CRamViewDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

  protected:
  LRESULT OnUpdateRamView(WPARAM wParam,LPARAM lParam);

  //{{AFX_MSG(CRamViewDlg)
  virtual BOOL PreTranslateMessage(MSG* pMsg);
  virtual void OnCancel();
  virtual void OnOK();
  afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
  afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
  afx_msg void OnClose();
  afx_msg void OnDestroy();
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnBeginlabeleditRamviewTree(NMHDR *pNMHDR, LRESULT *pResult);
  afx_msg void OnEndlabeleditRamviewTree(NMHDR *pNMHDR, LRESULT *pResult);
  afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
  afx_msg void OnRamShowemptyreg();
  afx_msg void OnRamShowFlags();
  afx_msg void OnRamVisible();
  afx_msg void OnRamAll();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()

  private:
  CMaskEdit *m_peditLine;

  static HTREEITEM __cdecl AddLeaf(CTreeCtrl *pTreeWnd, HTREEITEM hti, LPCTSTR lpFormat, ...);
  static INT GetBcd(BYTE CONST *pbyNum,INT nMantLen,INT nExpLen,CONST TCHAR cDec,LPTSTR cp,INT nSize);
  void DecodeReg(const struct RAM_REG *pRam,CString& strData) const;
  void CreateXmFileList(CMap<int, int, CString, CString>& mapText) const;
  void ShowMemCfgTree();
  void GetExpMemCfgTree(std::vector<UINT>& vState) const;
  void SetExpMemCfgTree(const std::vector<UINT>& vState);
  HTREEITEM GetTextMemCfgTree(HTREEITEM htiParent,CString& strText,bool bVisibleAll);
  void CopyRamToCopyClipboard(bool bVisibleAll);
};


/***********************/
// Edit Config dialog
/***********************/
class CEditConfig : public CDialog
  {
  public:
  CEditConfig(CWnd* pParent = NULL);
  HP41 *pHP41;
  CPtrList ModList;                     // pointers to temp module list for list box
  POSITION posList;                     // list box cursor position in module list
  void LoadListBox(void);

  //{{AFX_DATA(CEditConfig)
  enum { IDD = IDD_EDIT_CONFIG };
  CListBox ctlModList;
  CButton ctlInfo;
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CEditConfig)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

  protected:
  //{{AFX_MSG(CEditConfig)
  afx_msg void OnAdd();
  afx_msg void OnRemove();
  afx_msg void OnInfo();
  afx_msg void OnUp();
  afx_msg void OnDown();
  afx_msg void OnDblclkModList();
  virtual BOOL OnInitDialog();
  virtual void OnOK();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
  };

/***********************/
// Breakpoints List dialog
/***********************/
class CBreakPointsDlg : public CDialog
  {
  public:
  CBreakPointsDlg(CWnd* pParent = NULL);
  HP41 *pHP41;
  void LoadListBox(void);
  uint Left,Top;

  //{{AFX_DATA(CBreakPointsDlg)
  enum { IDD = IDD_BREAKPOINTS };
  CButton ctlEnable;
  CListBox ctlAddrList;
  CEdit ctlAddr;
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CBreakPointsDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

  protected:
  //{{AFX_MSG(CBreakPointsDlg)
  afx_msg void OnSet();
  afx_msg void OnClear();
  afx_msg void OnDblclkAddrList();
  afx_msg int OnVKeyToItem(UINT nKey, CListBox* pListBox, UINT nIndex);
  virtual BOOL OnInitDialog();
  afx_msg void OnEnable();
  virtual void OnCancel();
  virtual void OnOK();
  afx_msg void OnClose();
  afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
  afx_msg void OnDestroy();
  afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
  afx_msg void OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct);
  afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()

  private:
  HBITMAP hBmpCheckBox;

  void ToggleBreakpointItem(INT nItem);
  };

/////////////////////////////////////////////////////////////////////////////
// CTraceSettings dialog

class CTraceSettings : public CDialog
  {
// Construction
public:
  CTraceSettings(CWnd* pParent = NULL);   // standard constructor

  char szTraceFilename[_MAX_PATH];
  HP41::TRACE_MODE eTraceMode;  // trace mode new/append

  // trace content
  flag fTraceRegister;          // show register content in trace file
  flag fTraceOpcode;            // show the numeric opcode
  flag fOctal;                  // display PC address in octal
  flag fTraceHpil;              // show HP-IL frames

// Dialog Data
  //{{AFX_DATA(CTraceSettings)
  enum { IDD = IDD_TRACE };
    // NOTE: the ClassWizard will add data members here
  //}}AFX_DATA

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CTraceSettings)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  //}}AFX_VIRTUAL

// Implementation
protected:

  // Generated message map functions
  //{{AFX_MSG(CTraceSettings)
  virtual BOOL OnInitDialog();
  afx_msg void OnTraceBrowse();
  virtual void OnOK();
  virtual void OnCancel();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
  };

/////////////////////////////////////////////////////////////////////////////
// CRegisterValue dialog

class CRegisterValue : public CDialog
  {
// Construction
  public:
  CRegisterValue(CWnd* pParent = NULL);   // standard constructor

  void putRegister(byte *reg,uint reglen,uint base=16);
  void getRegister(byte *reg,uint reglen);

// Dialog Data
  //{{AFX_DATA(CRegisterValue)
  enum { IDD = IDD_REGVALUE };
    // NOTE: the ClassWizard will add data members here
  //}}AFX_DATA

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CRegisterValue)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  //}}AFX_VIRTUAL

// Implementation
  protected:

  // Generated message map functions
  //{{AFX_MSG(CRegisterValue)
  virtual BOOL OnInitDialog();
  virtual void OnOK();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()

  private:
  CString m_strValue;       // the register value
  CString m_strBaseFilter;  // filter for valid numbers

  void getFilter(uint base);
  };

/////////////////////////////////////////////////////////////////////////////
// CPageView dialog

class CPageView : public CDialog
{
// Construction
public:
  CPageView(CWnd* pParent = NULL);   // standard constructor
  HP41 *pHP41;

// Dialog Data
  //{{AFX_DATA(CPageView)
  enum { IDD = IDD_MODULES };
    // NOTE: the ClassWizard will add data members here
  //}}AFX_DATA


// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CPageView)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  //}}AFX_VIRTUAL

// Implementation
protected:

  // Generated message map functions
  //{{AFX_MSG(CPageView)
  afx_msg void OnOK();
  afx_msg void OnCancel();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
  DECLARE_MESSAGE_MAP()

private:
  bool ViewName(int nPage, int nFcn, CString& strTitle, CString& strName) const;
};
//{{AFX_INSERT_LOCATION}}
