/*=======================================================================

Author: Warren Furlow (email: warren@furlow.org)

License: PUBLIC DOMAIN - May be freely copied and incorporated into any work

Description:  Reads and checks a MOD file, then outputs its contents and info

=========================================================================*/

#define _CRT_SECURE_NO_WARNINGS
#define _CRT_NONSTDC_NO_WARNINGS

#define WIN32_LEAN_AND_MEAN
#include<windows.h>
#include<commdlg.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"MODFile.h"
#include"MODFileWin.h"

HINSTANCE hInst;
char szAppName[50];
char szAppClass[50];
char MODFileName[255]={""};

LRESULT CALLBACK WndProc(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK About(HWND,UINT,WPARAM,LPARAM);

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
  {
  LoadString(hInstance,IDS_APP_NAME,szAppName,sizeof(szAppName));
  LoadString(hInstance,IDS_APP_CLASS,szAppClass,sizeof(szAppClass));

  // register class
  WNDCLASS wc;
  wc.style=CS_HREDRAW|CS_VREDRAW;
  wc.lpfnWndProc=(WNDPROC)WndProc;
  wc.cbClsExtra=0;
  wc.cbWndExtra=0;
  wc.hInstance=hInstance;
  wc.hIcon=LoadIcon(hInstance,(LPCTSTR)IDI_APP);
  wc.hCursor=LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
  wc.lpszMenuName=MAKEINTRESOURCE(IDS_APP_NAME);
  wc.lpszClassName=szAppClass;
  if (!RegisterClass(&wc))
    return(FALSE);

  // create main window
  hInst=hInstance;
  HWND hWnd=CreateWindow(szAppClass,NULL,WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,0,CW_USEDEFAULT,0,NULL,NULL,hInstance,NULL);
  if (!hWnd)
    return(FALSE);
  ShowWindow(hWnd,nCmdShow);
  UpdateWindow(hWnd);

  // load resources
  HACCEL hAccelTable=LoadAccelerators(hInstance,szAppName);

  // main message loop
  MSG msg;
  while (GetMessage(&msg,NULL,0,0)) 
  {
    if (!TranslateAccelerator(msg.hwnd,hAccelTable,&msg)) 
      {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      }
    }
  return msg.wParam;
  }

// Main window proc
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
  {
  switch (message) 
    {
    case WM_COMMAND:
      {
      int wID=LOWORD(wParam); 
      int wNotifyCode=HIWORD(wParam); 
      switch (wID)
        {
        case IDM_FILE_INFO:
          {
          OPENFILENAME ofn;
          memset(&ofn,0,sizeof(OPENFILENAME));
          ofn.lStructSize=sizeof(OPENFILENAME);
          ofn.hwndOwner=GetActiveWindow();
          ofn.lpstrFile=MODFileName;
          ofn.nMaxFile=255;
          ofn.lpstrFilter="Module Files (*.mod)\0*.mod\0";
          ofn.nFilterIndex=1;
          ofn.lpstrInitialDir=NULL;
          ofn.Flags=OFN_HIDEREADONLY;
          if (GetOpenFileName(&ofn))
            {
            char MODInfoFileName[255]={""};
            char drive[_MAX_DRIVE],dir[_MAX_DIR],fname[_MAX_FNAME],ext[_MAX_EXT];
            _splitpath(MODFileName,drive,dir,fname,ext);
            _makepath(MODInfoFileName,drive,dir,fname,"txt");
            FILE *MODInfoFile=fopen(MODInfoFileName,"wt");
            int Res=output_mod_info(MODInfoFile,MODFileName,1,1,NULL);
            fclose(MODInfoFile);
            if (Res==0)
              {
              char szCommand[300];
              strcpy(szCommand,"notepad ");
              strcat(szCommand,MODInfoFileName);
              WinExec(szCommand,SW_SHOW);
              }
            else
              {
              if (Res==1)
                MessageBox(NULL,"Open Failure",NULL,MB_OK);
              else if (Res==2)
                MessageBox(NULL,"Read Failure",NULL,MB_OK);
              else if (Res==3)
                MessageBox(NULL,"Invalid Format",NULL,MB_OK);
              MODFileName[0]=0;
              }
            }
          else
            MODFileName[0]=0;
          SetWindowText(hWnd,MODFileName);
          break;
          }
        case IDM_FILE_EXTRACT:
          {
          if (MODFileName[0]==0)
            MessageBox(NULL,"No File Selected",NULL,MB_OK);
          else if (extract_roms(MODFileName))
            MessageBox(NULL,"Failure",NULL,MB_OK);
          else
            MessageBox(NULL,"Success","",MB_OK);
          break;
          }
        case IDM_FILE_EXIT:
          DestroyWindow(hWnd);
          break;
        case IDM_HELP_ABOUT:
          DialogBox(hInst,(LPCTSTR)IDD_ABOUT,hWnd,(DLGPROC)About);
          break;
        default:
          return(DefWindowProc(hWnd,message,wParam,lParam));
        }
      break;
      }
    case WM_DESTROY:
      {
      PostQuitMessage(0);
      break;
      }
    default:
      return(DefWindowProc(hWnd,message,wParam,lParam));
   }
  return(0);
  }

// About dialog
LRESULT CALLBACK About(HWND hDlg,UINT message,WPARAM wParam,LPARAM lParam)
  {
  switch (message)
    {
    case WM_INITDIALOG:
      return(TRUE);
    case WM_COMMAND:
      {
      if (LOWORD(wParam)==IDOK || LOWORD(wParam)==IDCANCEL) 
        {
        EndDialog(hDlg,LOWORD(wParam));
        return(TRUE);
        }
      break;
      }
    }
  return(FALSE);
  }
