/*=======================================================================

Author: Warren Furlow (email: warren@furlow.org)

License: PUBLIC DOMAIN - May be freely copied and incorporated into any work

Purpose: Converts ROM files into MOD files
         MODGen is setup to run under Visual C++ as a debug build

=======================================================================*/

#define _CRT_SECURE_NO_WARNINGS
#define _CRT_NONSTDC_NO_WARNINGS

#include<stdio.h>
#include<stdlib.h>
#include<memory.h>
#include<string.h>
#include"MODFile.h"

main()
  {
  word *ROM;
  ModuleFileHeader ModHeader;
  ModuleFilePage ModPage;
  FILE *ModFile;
  char HPDisclaimer[]="Hewlett-Packard Company makes no warranty as to the accuracy or completeness of the foregoing information and hereby disclaims any responsibility therefore.";

  /*** OPERATING SYSTEM ROMS ********************************************************/
  /* ROM revisions reference: EXTEND YOUR HP-41 by W. Mier-Jedrzejowicz, pages 639-642 */
  /* There have also been minor revisions that did not receive a new letter. */

  /* 41C Rev DDE - First 41C version */
  ModFile=fopen("..\\MOD\\NUT-C.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-41C");
  strcpy(ModHeader.Version,"DDE");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"Date Codes: 1926-1940 - All classical bugs");
  ModHeader.Category=CATEGORY_OS;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=3;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut0-D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT0-D");
  strcpy(ModPage.ID,"D");
  ModPage.Page=0;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut1-D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT1-D");
  strcpy(ModPage.ID,"D");
  ModPage.Page=1;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut2-E.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT2-E");
  strcpy(ModPage.ID,"E");
  ModPage.Page=2;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 41CV Rev GFF - First 41CV version */
  ModFile=fopen("..\\MOD\\NUT-CV-GFF.MOD","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-41CV");
  strcpy(ModHeader.Version,"GFF");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"Date Codes: 2035-84?? - Bugs 5, 7, 8 removed too. The first version of the HP-41CV");
  ModHeader.Category=CATEGORY_OS;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=4;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=3;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut0-G.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT0-G");
  strcpy(ModPage.ID,"G");
  ModPage.Page=0;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut1-F.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT1-F");
  strcpy(ModPage.ID,"F");
  ModPage.Page=1;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut2-F.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT2-F");
  strcpy(ModPage.ID,"F");
  ModPage.Page=2;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 41CV Rev HFF - Final 41CV version */
  ModFile=fopen("..\\MOD\\NUT-CV.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-41CV");
  strcpy(ModHeader.Version,"HFF");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"Date Codes: 84??-????  - The final version of the HP-41CV");
  ModHeader.Category=CATEGORY_OS;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=4;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=3;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut0-H.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT0-H");
  strcpy(ModPage.ID,"H");
  ModPage.Page=0;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut1-F.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT1-F");
  strcpy(ModPage.ID,"F");
  ModPage.Page=1;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut2-F.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT2-F");
  strcpy(ModPage.ID,"F");
  ModPage.Page=2;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 41CX Rev NFL */
  ModFile=fopen("..\\MOD\\NUT-CX.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-41CX");
  strcpy(ModHeader.Version,"NFL");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"Date Codes: 2329-???? - The final version of the HP-41CX");
  ModHeader.Category=CATEGORY_OS;
  ModHeader.Hardware=HARDWARE_TIMER;
  ModHeader.MemModules=4;
  ModHeader.XMemModules=1;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=6;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut0-N.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT0-N");
  strcpy(ModPage.ID,"N");
  ModPage.Page=0;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut1-F.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT1-F");
  strcpy(ModPage.ID,"F");
  ModPage.Page=1;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Nut2-L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NUT2-L");
  strcpy(ModPage.ID,"L");
  ModPage.Page=2;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\XFUNS3-2D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"XFUNS3-2D");
  strcpy(ModPage.ID,"EF2D");
  ModPage.Page=3;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\TIME-2C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"TIME-2C");
  strcpy(ModPage.ID,"TM2C");
  ModPage.Page=5;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\XFUNS5-2D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"XFUNS5-2D");
  strcpy(ModPage.ID,"TMXC");
  ModPage.Page=5;
  ModPage.PageGroup=0;
  ModPage.Bank=2;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);


  /*** HP HARDWARE ROMS ********************************************************/

  /* 82160A HP-IL Module */
  ModFile=fopen("..\\MOD\\Hpil.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-IL Module");
  strcpy(ModHeader.Version,"EH");
  strcpy(ModHeader.PartNumber,"82160A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_HPIL_PERPH;
  ModHeader.Hardware=HARDWARE_HPIL;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ILPrinter-2E.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ILPrinter-2E");
  strcpy(ModPage.ID,"PL2E");
  ModPage.Page=6;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\ILModule-1H.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ILModule-1H");
  strcpy(ModPage.ID,"CS1H");
  ModPage.Page=7;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Auto Start and Duplication ROM */
  ModFile=fopen("..\\MOD\\Autostart.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Automatic Start and Cassette Duplication Module");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"00041-15042");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_HPIL_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\AutoStart.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AutoStart");
  strcpy(ModPage.ID,"AS1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 44468A Data Acquisition-Control Pac */
  ModFile=fopen("..\\MOD\\Data-acq.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Data Acquisition-Control Pac");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"44468A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_HPIL_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\DataAcqL-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"DataAcqL-1B");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\DataAcqU-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"DataAcqU-1B");
  strcpy(ModPage.ID,"  @@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Extended I/O Module */
  ModFile=fopen("..\\MOD\\Ext-io.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Extended I/O Module");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"82183A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_HPIL_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ExtIO-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ExtIO-1A");
  strcpy(ModPage.ID,"IO1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* HP-IL Development Module */
  ModFile=fopen("..\\MOD\\Hpil-dev.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-IL Development Module");
  strcpy(ModHeader.Version,"BA");
  strcpy(ModHeader.PartNumber,"00041-15043");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_HPIL_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\HPILDevL-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HPILDevL-1B");
  strcpy(ModPage.ID,"PD1B");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\HPILDevU-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HPILDevU-1A");
  strcpy(ModPage.ID,"BF1A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* HPIL Diagnostic ROM */
  ModFile=fopen("..\\MOD\\HPIL-DIAG.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-IL Diagnostic Module");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"ET14048");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"This is an internal predecessor to the HP-IL Development Module");
  ModHeader.Category=CATEGORY_HPIL_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\HPIL-DIAG.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HPIL-DIAG");
  strcpy(ModPage.ID,"PD1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Plotter Module */
  ModFile=fopen("..\\MOD\\Plotter.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Plotter Module");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"82184A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_HPIL_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PlotterL-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PlotterL-1A");
  strcpy(ModPage.ID,"PL1A");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\PlotterU-2A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PlotterU-2A");
  strcpy(ModPage.ID,"PL2A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Card Reader */
  ModFile=fopen("..\\MOD\\Card-rdr.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Card Reader");
  strcpy(ModHeader.Version,"G");
  strcpy(ModHeader.PartNumber,"82104A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_CARDREADER;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\CrdRdr-1G.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CrdRdr-1G");
  strcpy(ModPage.ID,"CR1G");
  ModPage.Page=0xE;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Infrared Printer Module */
  ModFile=fopen("..\\MOD\\Ir-Print.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Infrared Printer Module");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"82242A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_INFRARED;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\IRPrinter1-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"IRPrinter1-1B");
  strcpy(ModPage.ID,"PR1B");
  ModPage.Page=6;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\IRPrinter2-3B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"IRPrinter2-3B");
  strcpy(ModPage.ID,"PS3B");
  ModPage.Page=6;
  ModPage.PageGroup=0;
  ModPage.Bank=2;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 82180A Extended Functions/Memory Module */
  ModFile=fopen("..\\MOD\\Ext-funs.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Extended Functions/Memory Module");
  strcpy(ModHeader.Version,"C");
  strcpy(ModHeader.PartNumber,"82180A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=1;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\XFUNS-1C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"XFUNS-1C");
  strcpy(ModPage.ID,"AP1C");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 82181A Extended Memory Module */
  ModFile=fopen("..\\MOD\\Ext-mem.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Extended Memory Module");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"82181A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=1;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=0;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  fclose(ModFile);

  /* 82106A Memory Module */
  ModFile=fopen("..\\MOD\\Mem.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Memory Module");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"82106A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=1;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=0;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  fclose(ModFile);

  /* 82170A Quad Memory Module */
  ModFile=fopen("..\\MOD\\Quadmem.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Quad Memory Module");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"82170A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=4;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=0;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  fclose(ModFile);

  /* Service ROM for HP-41C */
  ModFile=fopen("..\\MOD\\Service.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Service ROM for HP-41C");
  strcpy(ModHeader.Version,"1C");
  strcpy(ModHeader.PartNumber,"ET-11966");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Service-C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Service-C");
  strcpy(ModPage.ID,"SM1:C");
  ModPage.Page=4;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SERVICE ROM for HP-41C/CV */
  ModFile=fopen("..\\MOD\\Service-CV.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Service ROM for HP-41C/CV");
  strcpy(ModHeader.Version,"2A");
  strcpy(ModHeader.PartNumber,"ET-11966?");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"A slightly later revision of the original service module");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SERVICE2.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SERVICE2");
  strcpy(ModPage.ID,"SM2:A");
  ModPage.Page=4;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Diagnostic ROM for HP-41CX */
  ModFile=fopen("..\\MOD\\Diagnostic.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Diagnostic ROM for HP-41CV/X");
  strcpy(ModHeader.Version,"C");
  strcpy(ModHeader.PartNumber,"5061-7221");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Service-CX.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Service-CX");
  strcpy(ModPage.ID,"SM2:A");
  ModPage.Page=4;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 82143A Printer Service Module */
  ModFile=fopen("..\\MOD\\Printerservice.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"82143A Printer Service Module");
  strcpy(ModHeader.Version,"2B");
  strcpy(ModHeader.PartNumber,"ET-11968");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PrinterService.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PrinterService");
  strcpy(ModPage.ID,"SM2B");
  ModPage.Page=4;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 82143A Thermal Printer */
  ModFile=fopen("..\\MOD\\Printer.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Thermal Printer");
  strcpy(ModHeader.Version,"E");
  strcpy(ModHeader.PartNumber,"82143A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_PRINTER;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Printer-1E.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Printer-1E");
  strcpy(ModPage.ID,"PR1E");
  ModPage.Page=6;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 82182A Time Module */
  ModFile=fopen("..\\MOD\\Time.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Time Module");
  strcpy(ModHeader.Version,"C");
  strcpy(ModHeader.PartNumber,"82182A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_TIMER;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Time-1C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Time-1C");
  strcpy(ModPage.ID,"TM1C");
  ModPage.Page=5;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 82153A Wand */
  ModFile=fopen("..\\MOD\\Wand.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Barcode Wand");
  strcpy(ModHeader.Version,"F");
  strcpy(ModHeader.PartNumber,"82153A");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_STD_PERPH;
  ModHeader.Hardware=HARDWARE_WAND;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Wand-1F.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Wand-1F");
  strcpy(ModPage.ID,"WD1F");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /*** HP APPLICATION PACS ********************************************************/

  /* Advantage Pac */
  ModFile=fopen("..\\MOD\\Advantage.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Advantage Pac");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"00041-15055");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=3;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\AdvL1-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AdvL1-1B");
  strcpy(ModPage.ID,"ADV1");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\AdvU1-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AdvU1-1B");
  strcpy(ModPage.ID,"ADV2");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\AdvU2-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AdvU2-1B");
  strcpy(ModPage.ID,"ADV3");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=2;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Aviation Pac */
  ModFile=fopen("..\\MOD\\Aviation.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Aviation Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15018");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Aviation-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Aviation-1A");
  strcpy(ModPage.ID,"AV1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Circuit Analysis Pac */
  ModFile=fopen("..\\MOD\\Circuit.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Circuit Analysis Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15006");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Circuit-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Circuit-1A");
  strcpy(ModPage.ID,"CA1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Clinical Lab & Nuclear Medicine Pac */
  ModFile=fopen("..\\MOD\\Clinical.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Clinical Lab & Nuclear Medicine Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15024");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Clinical-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Clinical-1A");
  strcpy(ModPage.ID,"CL1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Financial Decisions Pac */
  ModFile=fopen("..\\MOD\\Finance.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Financial Decisions Pac");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"00041-15004");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Finance-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Finance-1D");
  strcpy(ModPage.ID,"FI1D");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Games Pac */
  ModFile=fopen("..\\MOD\\Games.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Games Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15022");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Games-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Games-1A");
  strcpy(ModPage.ID,"GA1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Home Management Pac */
  ModFile=fopen("..\\MOD\\Home-mgt.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Home Management Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15023");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\HomeMgt-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HomeMgt-1A");
  strcpy(ModPage.ID,"HM1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Machine Design Pac */
  ModFile=fopen("..\\MOD\\Machine.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Machine Design Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15020");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Machine-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Machine-1A");
  strcpy(ModPage.ID,"MD1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Math Pac */
  ModFile=fopen("..\\MOD\\Math.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Math Pac");
  strcpy(ModHeader.Version,"C");
  strcpy(ModHeader.PartNumber,"5061-5261");     /* 1A is 00041-15003 */
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Math-1C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Math-1C");
  strcpy(ModPage.ID,"MA1C");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Math/Stat Pac */
  ModFile=fopen("..\\MOD\\Mathstat.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Math/Stat Pac");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"5061-7287");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Math-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Math-1D");
  strcpy(ModPage.ID,"-M1D");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Stat-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Stat-1B");
  strcpy(ModPage.ID,"ST1B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Navigation Pac */
  ModFile=fopen("..\\MOD\\Navigation.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Navigation Pac");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"00041-15017");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\NavL-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NavL-1B");
  strcpy(ModPage.ID,"NA1B");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\NavU-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NavU-1B");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Petroleum Fluids Pac */
  ModFile=fopen("..\\MOD\\Petroleum.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Petroleum Fluids Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15039");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PetroleumL-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PetroleumL-1A");
  strcpy(ModPage.ID,"PE1A");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\PetroleumU-2A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PetroleumU-2A");
  strcpy(ModPage.ID,"PE2A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Real Estate Pac */
  ModFile=fopen("..\\MOD\\Real-Estate.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Real Estate Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15016");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\RealEstateL-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"RealEstateL-1A");
  strcpy(ModPage.ID,"RE1A");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\RealEstateU-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"RealEstateU-1A");
  strcpy(ModPage.ID,"RE1A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Securities Pac */
  ModFile=fopen("..\\MOD\\Securities.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Securities Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15026");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Securities-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Securities-1A");
  strcpy(ModPage.ID,"SE1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Standard Applications Pac */
  ModFile=fopen("..\\MOD\\Standard.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Standard Applications Pac");
  strcpy(ModHeader.Version,"C");
  strcpy(ModHeader.PartNumber,"00041-15001");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Standard-1C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Standard-1C");
  strcpy(ModPage.ID,"ST1C");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.BankGroup=0;
  ModPage.Bank=1;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Stat Pac */
  ModFile=fopen("..\\MOD\\Stat.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Stat Pac");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"00041-15002");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Stat-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Stat-1B");
  strcpy(ModPage.ID,"ST1B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Stress Analysis Pac */
  ModFile=fopen("..\\MOD\\Stress.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Stress Analysis Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15027");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Stress-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Stress-1A");
  strcpy(ModPage.ID,"ME1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Structural Analysis Pac */
  ModFile=fopen("..\\MOD\\Structural.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Structural Analysis Pac");
  strcpy(ModHeader.Version,"BA");
  strcpy(ModHeader.PartNumber,"00041-15021");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\StructL-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"StructL-1B");
  strcpy(ModPage.ID,"CE1B");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\StructU-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"StructU-1A");
  strcpy(ModPage.ID,"CB1A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Surveying Pac */
  ModFile=fopen("..\\MOD\\Survey.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Surveying Pac");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"00041-15005");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Survey-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Survey-1B");
  strcpy(ModPage.ID,"SU1B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Thermal & Transport Science Pac */
  ModFile=fopen("..\\MOD\\Thermal.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Thermal & Transport Science Pac");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"00041-15019");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_APP_PAC;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Thermal-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Thermal-1A");
  strcpy(ModPage.ID,"TT1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /*** HP LIBRARY COMPILATIONS ********************************************************/

  /* Chemistry User Library Pac */
  /* Steps to create: I made and the Users Library Solutions book the programs are from. Actually, I
     used the raw files. I load the raw into V41, fix any problems, like duplicate labels, or typos.
     I run the program according to the users book to test. Then I convert to .lif files using the
     win41uc file utility on your DVD. Next, I import the lif files into emu41, upload them into the
     storage device, and compile, etc using the w&w rambox op system. Then export using Christopher Klugs
     lower/upper program, use clbin41 to convert to .rom, and voila, a new ROM!!  David Bookin */
  ModFile=fopen("..\\MOD\\ChemUser.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Chemistry User Library ROM");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Hewlett-Packard");
  strcpy(ModHeader.Copyright,"Hewlett-Packard");
  strcpy(ModHeader.License,HPDisclaimer);
  strcpy(ModHeader.Comments,"This is a collection of programs compiled from the Chemistry User's Library Solutions Book by David Bookin");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ChemUser.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ChemUser");
  strcpy(ModPage.ID,"CH01");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /*** 3RD PARTY ROMS ********************************************************/

  /* Advantage Application ROM */
  ModFile=fopen("..\\MOD\\Adv-app.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Advantage Application ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Various Grapevine Publications");
  strcpy(ModHeader.Copyright,"Grapevine Publications");
  strcpy(ModHeader.License,"Reproduced by Permission");
  strcpy(ModHeader.Comments,"Compiled by Jean-Franois Garnier");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Adv-App.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Adv-App");
  strcpy(ModPage.ID,"AA1A");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  /* AECROM */
  ModFile=fopen("..\\MOD\\Aecrom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"AECROM Module");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Redshift Software");
  strcpy(ModHeader.Copyright,"Redshift Software");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\aecromL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"aecromL");
  strcpy(ModPage.ID,"A;,;,C.");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\aecromU.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"aecromU");
  strcpy(ModPage.ID,"AE1A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ALPHA ROM */
  ModFile=fopen("..\\MOD\\Alpha.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ALPHA ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ngel Martin");
  strcpy(ModHeader.Copyright,"2005 ngel Martin");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ALPHA.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ALPHA");
  strcpy(ModPage.ID,"WN41");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* BLDROM */
  ModFile=fopen("..\\MOD\\Bldrom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"BLDROM");
  strcpy(ModHeader.Version,"1D");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"William D. Wilder");
  strcpy(ModHeader.Copyright,"William D. Wilder");
  strcpy(ModHeader.License,"Permission granted to post on hp41.org");
  strcpy(ModHeader.Comments,"Never sent to manufacturing for public release");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\BLDROM.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"BLDROM");
  strcpy(ModPage.ID,"BL1D");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* CCD Module */
  ModFile=fopen("..\\MOD\\Ccd.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"CCD Module");
  strcpy(ModHeader.Version,"B");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"W&W Software Products GmbH");
  strcpy(ModHeader.Copyright,"W&W Software Products GmbH ");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\CCDL-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CCDL-1B");
  strcpy(ModPage.ID,"WW1B");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\CCDU-2B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CCDU-2B");
  strcpy(ModPage.ID,"WW2B");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* CMT200 */
  ModFile=fopen("..\\MOD\\CMT-200.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"CMT-200 Data Acquisition and Control System");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Corvallis MicroTechnology, Inc.");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\CMT-200.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CMT-200");
  strcpy(ModPage.ID,"CMT1");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* CMT300 */
  ModFile=fopen("..\\MOD\\CMT-300.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"CMT-300");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Corvallis MicroTechnology, Inc.");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\CMT-300L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CMT-300L");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\CMT-300U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CMT-300U");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* David Assembler */
  ModFile=fopen("..\\MOD\\David.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"David Assembler");
  strcpy(ModHeader.Version,"2C");
  strcpy(ModHeader.PartNumber,"84081B");
  strcpy(ModHeader.Author,"David A. van Leeuwen");
  strcpy(ModHeader.Copyright,"1984-2003 David A. van Leeuwen");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\David-2C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"David-2C");
  strcpy(ModPage.ID,"DA2C");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Labels.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Labels");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ERAMCO ES-41 RSU Database */
  ModFile=fopen("..\\MOD\\Es-41.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ERAMCO ES-41 RSU Database");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ERAMCO SYSTEMS B.V.");
  strcpy(ModHeader.Copyright,"1986 ERAMCO SYSTEMS B.V.");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"Requires 24K RAM also");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ES41L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ES41L");
  strcpy(ModPage.ID,"R.S:D.F.");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\ES41U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ES41U");
  strcpy(ModPage.ID,"R.S:A.F.");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ERAMCO MLDL X10 */
  ModFile=fopen("..\\MOD\\Es-mldl-x10.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ERAMCO MLDL Operating System XROM 10 Ver 7B");
  strcpy(ModHeader.Version,"7B");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ERAMCO SYSTEMS B.V.");
  strcpy(ModHeader.Copyright,"1984 ERAMCO SYSTEMS B.V.");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ESMLDL-7B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ES-MLDL");
  strcpy(ModPage.ID,"OS7B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ERAMCO MLDL X11 */
  ModFile=fopen("..\\MOD\\Es-mldl-x11.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ERAMCO MLDL Operating System XROM 11");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ERAMCO SYSTEMS B.V.");
  strcpy(ModHeader.Copyright,"1984 ERAMCO SYSTEMS B.V.");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ESMLDL11.rom");
  ROM[0x0fff]=compute_checksum(ROM);      // original checksum 168 was wrong
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ES-MLDL");
  strcpy(ModPage.ID,"AS A");   // could be a typo - maybe ES A as in Eramco Systems Addendum or OS A?
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* FORTH ROM */
  ModFile=fopen("..\\MOD\\Forth.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"FORTH 41");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Serge Vaudenay");
  strcpy(ModHeader.Copyright,"Serge Vaudenay");
  strcpy(ModHeader.License,"Reproduced by permission");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\FORTH4.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"FORTH4");
  strcpy(ModPage.ID,"SV05:");
  ModPage.Page=4;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\FORTH5.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"FORTH5");
  strcpy(ModPage.ID,"SV06:");
  ModPage.Page=5;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* EXT-IL */
  ModFile=fopen("..\\MOD\\Ext-il.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Extended IL ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Skwid Ink");
  strcpy(ModHeader.Copyright,"1986 Skwid Ink");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\EXT-IL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"EXT-IL");
  strcpy(ModPage.ID,"C.F,<9.");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* The HEPAX ROM must start out in an EVEN numbered port page (8,A,C,E).  Upon power-on, it will then try
  to relocate itself to an empty page starting at 5. When it does, the RAM page that it was on top of
  will then be visible. The other RAM page and all subsequent ones must start at the next page
  Modules made: Standard: HEPAX+8K RAM, Advanced: HEPAX+16K RAM, MEMORY: 8K RAM, Double MEMORY: 16K RAM */
  ModFile=fopen("..\\MOD\\Hepax.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Standard HEPAX Module");
  strcpy(ModHeader.Version,"D");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"VM Electronics");
  strcpy(ModHeader.Copyright,"Steen Petersen");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"8K RAM");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_HEPAX;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=6;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax1-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax1-1D");
  strcpy(ModPage.ID,"H11D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax2-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax2-1D");
  strcpy(ModPage.ID,"H21D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=2;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax3-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax3-1D");
  strcpy(ModPage.ID,"H31D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=3;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax4-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax4-1D");
  strcpy(ModPage.ID,"H41D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=4;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HEP-STD-RAM1");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.WriteProtect=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HEP-STD-RAM2");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ODD;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.WriteProtect=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Advanced HEPAX Module - 16K RAM */
  ModFile=fopen("..\\MOD\\HepaxAdv.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Advanced HEPAX Module");
  strcpy(ModHeader.Version,"D");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"VM Electronics");
  strcpy(ModHeader.Copyright,"Steen Petersen");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"16K RAM");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_HEPAX;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=8;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax1-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax1-1D");
  strcpy(ModPage.ID,"H11D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax2-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax2-1D");
  strcpy(ModPage.ID,"H21D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=2;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax3-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax3-1D");
  strcpy(ModPage.ID,"H31D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=3;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Hepax4-1D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Hepax4-1D");
  strcpy(ModPage.ID,"H41D");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=4;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HEP-ADV-RAM1");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_EVEN;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.WriteProtect=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"HEP-ADV-RAM2");
  ModPage.Page=POSITION_ODD;
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"HEP-ADV-RAM3");
  ModPage.Page=POSITION_ORDERED;
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"HEP-ADV-RAM4");
  ModPage.Page=POSITION_ORDERED;
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* HEPAX Memory Module- 8K RAM */
  ModFile=fopen("..\\MOD\\Hep-mem.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HEPAX Memory Module 8K");
  strcpy(ModHeader.Version,"C");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"VM Electronics");
  strcpy(ModHeader.Copyright,"Steen Petersen");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"8K RAM");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_HEPAX;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.WriteProtect=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  strcpy(ModPage.Name,"HEP-MEM-RAM1");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"HEP-MEM-RAM2");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* HEPAX Memory Module- 16K RAM */
  ModFile=fopen("..\\MOD\\Hep-2mem.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HEPAX Memory Module 16K");
  strcpy(ModHeader.Version,"C");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"VM Electronics");
  strcpy(ModHeader.Copyright,"Steen Petersen");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"16K RAM");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_HEPAX;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=4;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.WriteProtect=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  strcpy(ModPage.Name,"HEP-2MEM-RAM1");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"HEP-2MEM-RAM2");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"HEP-2MEM-RAM3");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"HEP-2MEM-RAM4");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* HP-41Z */
  ModFile=fopen("..\\MOD\\41Z.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"HP-41Z Complex Number Module");
  strcpy(ModHeader.Version,"4L");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ngel Martin");
  strcpy(ModHeader.Copyright,"2004-10 ngel Martin");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\41ZL.rom");
  ROM[0x0fff]=compute_checksum(ROM);
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"41ZL");
  strcpy(ModPage.ID,"AM9Z");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\41ZU.rom");
  ROM[0x0fff]=compute_checksum(ROM);
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"41ZU");
  strcpy(ModPage.ID,"MA9Z");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* HYDRACOMP */
  ModFile=fopen("..\\MOD\\Hydracomp.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Hydracomp");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Paul-Munroe Hydraulics, Inc.");
  strcpy(ModHeader.Copyright,"1982 Paul-Munroe Hydraulics, Inc.");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"P-28 Hydraulics Module");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\HYDRACMP.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"HYDRACMP");
  strcpy(ModPage.ID,"HYMP");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ICEBOX ROM */
  ModFile=fopen("..\\MOD\\Icebox.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ICEBOX ROM");
  strcpy(ModHeader.Version,"1H");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Geir Isene");
  strcpy(ModHeader.Copyright,"2010 Geir Isene, ngel Martin");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"Modified TOOLBOX ROM to switch RAM blocks via a FOCAL program");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ICEBOX.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ICEBOX");
  strcpy(ModPage.ID,"IB1H");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* JMB Math ROM */
  ModFile=fopen("..\\MOD\\Jmb-math.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"JMB MATH ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Jean-Marc Baillard");
  strcpy(ModHeader.Copyright,"2010 Jean-Marc Baillard");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\JMB-MATHL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  ROM[0x0fff]=compute_checksum(ROM);
  strcpy(ModPage.Name,"JMB-MATHL");
  strcpy(ModPage.ID,"JB1A");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\JMB-MATHU.rom");
  memset(&ModPage,0,sizeof(ModPage));
  ROM[0x0fff]=compute_checksum(ROM);
  strcpy(ModPage.Name,"JMB-MATHU");
  strcpy(ModPage.ID,"JB1A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* LAITRAM XQ2 */
  ModFile=fopen("..\\MOD\\Laitram-XQ2.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Laitram XQ2");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Firmware Specialists, Inc.");
  strcpy(ModHeader.Copyright,"Laitram, L.L.C.");
  strcpy(ModHeader.License,"Permission granted to post on hp41.org");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Laitram-XQ2.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Laitram");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=4;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* LandNav */
  ModFile=fopen("..\\MOD\\Landnav.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"LandNav Orienteering Module");
  strcpy(ModHeader.Version,"A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Warren Furlow");
  strcpy(ModHeader.Copyright,"1987 Warren Furlow");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\LandNav.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"LandNav");
  strcpy(ModPage.ID,"LN1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ML ROM */
  ModFile=fopen("..\\MOD\\Mlrom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ML ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Frits Ferwerda and others as noted");
  strcpy(ModHeader.Copyright,"Frits Ferwerda");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"Includes code by Meindert Kuipers, Assembler 3 and Eramco O/S");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MLROM.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MLROM");
  strcpy(ModPage.ID,"ML9B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MC EPROM Set */
  ModFile=fopen("..\\MOD\\Mc-eprom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Mountain Computer EPROM Set");
  strcpy(ModHeader.Version,"1C");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Paul Lind");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"Public Domain");
  strcpy(ModHeader.Comments,"For use with MC00506A EPROM Programmer");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MCEPROM-1C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MCEPROM-1C");
  strcpy(ModPage.ID,"NC1B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* NFC ROM */
  ModFile=fopen("..\\MOD\\Nfcrom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"NFCROM");
  strcpy(ModHeader.Version,"1B");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Nelson F. Crowle");
  strcpy(ModHeader.Copyright,"Nelson F. Crowle");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\NFCROM-1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NFCROM-1B");
  strcpy(ModPage.ID,"NC1B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Oilwell Module */
  ModFile=fopen("..\\MOD\\Oilwell.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"OILWELL Module");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Jim Daly");
  strcpy(ModHeader.Copyright,"1983 Daly Drilling Enterprises Limited");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\OILWELL-L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  ROM[0x0fff]=compute_checksum(ROM);
  strcpy(ModPage.Name,"OILWELL-L");
  strcpy(ModPage.ID,"*OL1");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\OILWELL-U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  ROM[0x0fff]=compute_checksum(ROM);
  strcpy(ModPage.Name,"OILWELL-U");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* PANAME ROM */
  ModFile=fopen("..\\MOD\\PANAME.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"PANAME ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Stphane Barizien and Jean-Jacques Dhnin");
  strcpy(ModHeader.Copyright,"Stphane Barizien and Jean-Jacques Dhnin");
  strcpy(ModHeader.License,"Published by permission on HP41.org for the sole purpose of preserving the HP-41's history.");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PanameL-3C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PanameL-3C");
  strcpy(ModPage.ID,"XP3C");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\PanameU-2A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PanameU-2A");
  strcpy(ModPage.ID,"MT2A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* PROFISET */
  ModFile=fopen("..\\MOD\\Profiset.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"MBK Profiset 2");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ProfisetL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ProfisetL");
  strcpy(ModPage.ID,"PS1G:");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\ProfisetU.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ProfisetU");
  strcpy(ModPage.ID,"PS2G:");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ProtoPARIO */
  ModFile=fopen("..\\MOD\\Protopario.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ProtoPARIO");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Nelson F. Crowle");
  strcpy(ModHeader.Copyright,"Nelson F. Crowle");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PARIO.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PARIO");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ProtoCODER */
  ModFile=fopen("..\\MOD\\Protocoder2.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ProtoCODER2");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Nelson F. Crowle");
  strcpy(ModHeader.Copyright,"Nelson F. Crowle");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PCODER-1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PCODER-1A");
  strcpy(ModPage.ID,"PC1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* PPC ROM */
  ModFile=fopen("..\\MOD\\Ppc.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"PPC ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"PPC");
  strcpy(ModHeader.Copyright,"PPC");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PPCL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PPCL");
  strcpy(ModPage.ID,"C 81");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\PPCU.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PPCU");
  strcpy(ModPage.ID,"");         /* actual value is 0000 which is all 0x30 */
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SANDBOX */
  ModFile=fopen("..\\MOD\\Sandbox.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"SANDBOX ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ngel Martin and others as noted");
  strcpy(ModHeader.Copyright,"2003 ngel Martin");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SandboxL-3D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SandboxL-3D");
  strcpy(ModPage.ID,"SB3D");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\SandboxU-3D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SandboxU-3D");
  strcpy(ModPage.ID,"SB4U");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SANDMATH */
  ModFile=fopen("..\\MOD\\Sandmath.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"SandMath ROM");
  strcpy(ModHeader.Version,"6");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ngel Martin and others as noted");
  strcpy(ModHeader.Copyright,"2003-2009 ngel Martin");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SandMathL.rom");
  ROM[0x0fff]=compute_checksum(ROM);
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SandMathL");
  strcpy(ModPage.ID,"SM6B");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\SandMathU.rom");
  ROM[0x0fff]=compute_checksum(ROM);
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SandMathU");
  strcpy(ModPage.ID,"HL6B");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SGS REDWOOD GAS CALCULATOR */
  ModFile=fopen("..\\MOD\\Sgs-gas.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"SGS Redwood Gas Calculator");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"SGS Redwood");
  strcpy(ModHeader.Copyright,"SGS Redwood");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SGS-GAS.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SGS-GAS");
  strcpy(ModPage.ID,"GALE");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SIMPLEX ROM */
  ModFile=fopen("..\\MOD\\Simplex.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"SIMPLEX");
  strcpy(ModHeader.Version,"2");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Phillippe J. Roussel");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"Updated version corrected some errors");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SIMPLEX.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SIMPLEX");
  strcpy(ModPage.ID,"SXV2");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SKWID BARCODE */
  ModFile=fopen("..\\MOD\\Skwidbc.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Skwid Barcode");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SkwidBC.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SkwidBC");
  strcpy(ModPage.ID,"BC41");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* Speed Machine II */
  ModFile=fopen("..\\MOD\\Speed-machine2.MOD","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Speed Machine II");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"82500B-A47");
  strcpy(ModHeader.Author,"Alameda Management Corporation");
  strcpy(ModHeader.Copyright,"1983 Alameda Management Corporation");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"Horse Racing - Password=55");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SPEED-MACHINE2L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SPEED-MACHINE2L");
  strcpy(ModPage.ID,"SMII");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\SPEED-MACHINE2U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SPEED-MACHINE2U");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SUP-R-ROM */
  ModFile=fopen("..\\MOD\\Sup-r-rom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"SUP-R-ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"James W. Vick");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SUP-R-ROM-L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SUP-R-ROM-L");
  strcpy(ModPage.ID,"SUOM");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\SUP-R-ROM-U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SUP-R-ROM-U");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* TOMSROM */
  ModFile=fopen("..\\MOD\\Tomsrom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"TOMSROM");
  strcpy(ModHeader.Version,"1");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Tom Bruns");
  strcpy(ModHeader.Copyright,"Tom Bruns");
  strcpy(ModHeader.License,"Reproduced by Permission");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\TOMSROM.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"TOMSROM");
  strcpy(ModPage.ID,"C. 86");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* TOOLBOX ROM */
  ModFile=fopen("..\\MOD\\Toolbox.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"TOOLBOX ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ngel Martin");
  strcpy(ModHeader.Copyright,"2005 ngel Martin");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\TOOLBOX.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"TOOLBOX");
  strcpy(ModPage.ID,"SB4U");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* UNITCONV */
  ModFile=fopen("..\\MOD\\Unitconv.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Unit Converter");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"ngel Martin, Peter Platzer");
  strcpy(ModHeader.Copyright,"2010 ngel Martin, Peter Platzer");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\UNITCONV.rom");
  ROM[0x0fff]=compute_checksum(ROM);
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"UNITCONV");
  strcpy(ModPage.ID,"UC2B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 4K RAM for MLDL */
  ModFile=fopen("..\\MOD\\Ram4k.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"4K RAM for MLDL");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"RAM4K-1");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 8K RAM for MLDL */
  ModFile=fopen("..\\MOD\\Ram8k.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"8K RAM for MLDL");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  strcpy(ModPage.Name,"RAM8K-1");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM8K-2");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 16K RAM for MLDL */
  ModFile=fopen("..\\MOD\\Ram16k.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"16K RAM for MLDL");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=4;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  strcpy(ModPage.Name,"RAM16K-1");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM16K-2");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM16K-3");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM16K-4");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 32K RAM for MLDL */
  ModFile=fopen("..\\MOD\\Ram32k.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"32K RAM for MLDL");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=8;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=1;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  strcpy(ModPage.Name,"RAM32K-1");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM32K-2");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM32K-3");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM32K-4");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM32K-5");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM32K-6");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM32K-7");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  strcpy(ModPage.Name,"RAM32K-8");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* 32K W&W RAMBOX I */
  ModFile=fopen("..\\MOD\\WWramboxI.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"32K W&W RAMBOX I");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"W&W Software Products GmbH");
  strcpy(ModHeader.Copyright,"W&W Software Products GmbH ");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_WWRAMBOX;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=8;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\WWRambox1.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"WWRambox1");
  strcpy(ModPage.ID,"WW3M");
  ModPage.Page=8;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.PageGroup=0;
  ModPage.BankGroup=1;
  ModPage.RAM=1;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  // 32K BLOCK "A"
  ModPage.Bank=1;
  ModPage.Page=9;
  strcpy(ModPage.Name,"WWRAM-2A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xA;
  strcpy(ModPage.Name,"WWRAM-3A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xB;
  strcpy(ModPage.Name,"WWRAM-4A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xC;
  strcpy(ModPage.Name,"WWRAM-5A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xD;
  strcpy(ModPage.Name,"WWRAM-6A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xE;
  strcpy(ModPage.Name,"WWRAM-7A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xF;
  strcpy(ModPage.Name,"WWRAM-8A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);
  fclose(ModFile);

  /* 64K W&W RAMBOX II */
  ModFile=fopen("..\\MOD\\WWramboxII.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"64K W&W RAMBOX II");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"W&W Software Products GmbH");
  strcpy(ModHeader.Copyright,"W&W Software Products GmbH ");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_WWRAMBOX;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=1;
  ModHeader.NumPages=16;
  ModHeader.HeaderCustom[0] = 0; // 0=all pages bank1, 1=odd pages bank2, 2=even pages bank2, 3=all pages bank2
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\WWRambox2A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"WWRambox2A");
  strcpy(ModPage.ID,"WW4D");
  ModPage.Page=8;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.PageGroup=0;
  ModPage.BankGroup=1;
  ModPage.RAM=1;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  // 32K BLOCK "A"
  ModPage.Bank=1;
  ModPage.Page=9;
  strcpy(ModPage.Name,"WWRAM-2A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xA;
  strcpy(ModPage.Name,"WWRAM-3A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xB;
  strcpy(ModPage.Name,"WWRAM-4A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xC;
  strcpy(ModPage.Name,"WWRAM-5A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xD;
  strcpy(ModPage.Name,"WWRAM-6A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xE;
  strcpy(ModPage.Name,"WWRAM-7A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xF;
  strcpy(ModPage.Name,"WWRAM-8A");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\WWRambox2B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"WWRambox2B");
  strcpy(ModPage.ID,"WW5D");
  ModPage.Page=8;
  ModPage.PageGroup=0;
  ModPage.Bank=2;
  ModPage.BankGroup=1;
  ModPage.RAM=0;
  ModPage.WriteProtect=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\blank.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.ID,"");
  ModPage.PageGroup=0;
  ModPage.BankGroup=1;
  ModPage.RAM=1;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);

  // 32K BLOCK "B"
  ModPage.Bank=2;
  ModPage.Page=9;
  strcpy(ModPage.Name,"WWRAM-2B");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xA;
  strcpy(ModPage.Name,"WWRAM-3B");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xB;
  strcpy(ModPage.Name,"WWRAM-4B");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xC;
  strcpy(ModPage.Name,"WWRAM-5B");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xD;
  strcpy(ModPage.Name,"WWRAM-6B");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xE;
  strcpy(ModPage.Name,"WWRAM-7B");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ModPage.Page=0xF;
  strcpy(ModPage.Name,"WWRAM-8B");
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ZENROM */
  ModFile=fopen("..\\MOD\\Zenrom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ZENROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"82500A-E36");
  strcpy(ModHeader.Author,"Zengrange");
  strcpy(ModHeader.Copyright,"Copyright 1984-2006 Zengrange Defence Systems, Ltd, UK.  Reproduced by permission on hp41.org");
  strcpy(ModHeader.License,"Zengrange makes no warranty as to the accuracy or completeness of the foregoing information and hereby disclaims any responsibility therefore.");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Zenrom-3B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Zenrom-3B");
  strcpy(ModPage.ID,"Z)L:A.");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ZEPROM */
  ModFile=fopen("..\\MOD\\Zeprom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ZEPROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Zengrange");
  strcpy(ModHeader.Copyright,"Copyright 1988-2006 Zengrange Defence Systems, Ltd, UK.  Reproduced by permission on hp41.org");
  strcpy(ModHeader.License,"Zengrange makes no warranty as to the accuracy or completeness of the foregoing information and hereby disclaims any responsibility therefore.");
  strcpy(ModHeader.Comments,"This is the code used in the Zeprom burner");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Zeprom.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Zeprom");
  strcpy(ModPage.ID,"I,9:G#");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /*** POORLY DOCUMENTED ROMS ********************************************************/

  /* 83TRINH */
  ModFile=fopen("..\\MOD\\83TRINH.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"83TRINH");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\83TRINH.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"83TRINH");
  strcpy(ModPage.ID,"SD1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* GUNZEN / MORZEN ROMS by ZENGRANGE  - AFDC1 & 2 used together and required for L119 apparently */
  /* artillery and mortar fire usage */

  /* AFDC1 */
  /* cat2 lists it as MFDC2-MDP38 */
  ModFile=fopen("..\\MOD\\AFDC1.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"AFDC1");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"MFDC2-MDP38");
  strcpy(ModHeader.Author,"Zengrange");
  strcpy(ModHeader.Copyright,"Copyright Zengrange Defence Systems, Ltd, UK.");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\AFDC1L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AFDC1L");
  strcpy(ModPage.ID,"J,O.>:}");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\AFDC1U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AFDC1U");
  strcpy(ModPage.ID,"J,O.>:}");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* AFDC2 */
  ModFile=fopen("..\\MOD\\AFDC2.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"AFDC2");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Zengrange");
  strcpy(ModHeader.Copyright,"Copyright Zengrange Defence Systems, Ltd, UK.");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\AFDC2L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AFDC2L");
  strcpy(ModPage.ID,"J,O.>:}");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\AFDC2U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AFDC2U");
  strcpy(ModPage.ID,"J,O.>:}");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* APAC */
  ModFile=fopen("..\\MOD\\APAC.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Aviation PAC 1982 for P-3B/C Orion");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"IDI");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=4;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\APAC1.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"APAC1");
  strcpy(ModPage.ID,"    ");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=0;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\APAC2.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"APAC2");
  strcpy(ModPage.ID,"(C)I");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\APAC3.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"APAC3");
  strcpy(ModPage.ID,"(C)I");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\APAC4.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"APAC4");
  strcpy(ModPage.ID,"    ");
  ModPage.Page=POSITION_ORDERED;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ASSEMBLER 3 */
  ModFile=fopen("..\\MOD\\Assembler3.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Assembler 3");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Assembler3.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Assembler3");
  strcpy(ModPage.ID,"MT3A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ASSEMBLER 4 */
  /* This very rare ROM has two damaged functions (not sure which) probably due to EPROM UV exposure */
  ModFile=fopen("..\\MOD\\Assembler4.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Assembler 4");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Assembler4.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Assembler4");
  strcpy(ModPage.ID,"AS4D");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ASTROLOGY */
  ModFile=fopen("..\\MOD\\Astrology.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Astrology ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Astrology.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Astrology");
  strcpy(ModPage.ID,"--EK");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* AUTOFINANCE */
  ModFile=fopen("..\\MOD\\Autofinance.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Auto Finance");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Autofinance.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Autofinance");
  strcpy(ModPage.ID,"AUCE");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* AV1 */
  ModFile=fopen("..\\MOD\\Beechcraft.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Aviation ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Beechcraft");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\AV1.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"AV1");
  strcpy(ModPage.ID,"-A1-");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* B52 */
  ModFile=fopen("..\\MOD\\Boeing-B52.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Boeing B52 ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\B52DIO.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"B52DIO");
  strcpy(ModPage.ID,"B5IO");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\B52DEX.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"B52DEX");
  strcpy(ModPage.ID,"B5EX");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* BCMW */
  ModFile=fopen("..\\MOD\\Bcmw.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"BCMW");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\BCMW1.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"BCMW");
  strcpy(ModPage.ID,"BCMW");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\BCMW2.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"BCMW");
  strcpy(ModPage.ID,"BCMW:");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* CV-PAK */
  ModFile=fopen("..\\MOD\\Cvpak.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"CV-PAK");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Michael G. Hadaway");
  strcpy(ModHeader.Copyright,"Michael G. Hadaway");
  strcpy(ModHeader.License,"ALL RIGHTS RESERVED");
  strcpy(ModHeader.Comments,"Control Valve Sizing");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\CVPAK1.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CVPAK1");
  strcpy(ModPage.ID,"CV1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\CVPAK2.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"CVPAK2");
  strcpy(ModPage.ID,"@@,2A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* DIAMOND */
  ModFile=fopen("..\\MOD\\Diamond.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Diamond ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\DIAMOND.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"DIAMOND");
  strcpy(ModPage.ID,"DIEL");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* DISASM 4C */
  ModFile=fopen("..\\MOD\\Disasm4C.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"DISASM");
  strcpy(ModHeader.Version,"4C");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"William Doug Wilder");
  strcpy(ModHeader.Copyright,"2006 William Doug Wilder");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\DISASM4C.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"DISASM4C");
  strcpy(ModPage.ID,"DA4C");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* DISASM 4D */
  ModFile=fopen("..\\MOD\\Disasm4D.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"DISASM");
  strcpy(ModHeader.Version,"4D");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"William Doug Wilder");
  strcpy(ModHeader.Copyright,"2009 William Doug Wilder");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\DISASM4D.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"DISASM4D");
  strcpy(ModPage.ID,"DA4D");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* DYERKA - TEST ROM 1 */
  ModFile=fopen("..\\MOD\\Dyerka.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Test ROM 1");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\DYERKA.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"DYERKA");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* GIRAULT
  ModFile=fopen("..\\MOD\\GIRAULT.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"GIRAULT Survey ROM");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Emmanuel Comps");
  strcpy(ModHeader.Copyright,"Emmanuel Comps");
  strcpy(ModHeader.License,"Not Granted");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\GIRAULT.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"GIRAULT");
  strcpy(ModPage.ID,"-GIR");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);
*/

  /* GMAC II */
  ModFile=fopen("..\\MOD\\Gmac2.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"GMAC II");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\GMAC2.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"GMAC2");
  strcpy(ModPage.ID,"AUTO");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* GMAC III */
  ModFile=fopen("..\\MOD\\Gmac3.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"GMAC III");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"82509A-SO5");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\GMAC3L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"GMAC3L");
  strcpy(ModPage.ID,"-GMA");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\GMAC3U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"GMAC3U");
  strcpy(ModPage.ID,"-GMA");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ICODE */
  ModFile=fopen("..\\MOD\\Icode.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ICODE");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"See PPC TECHNICAL NOTES #16");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ICODE.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ICODE");
  strcpy(ModPage.ID,"PC04");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* LABELS ROM */
  ModFile=fopen("..\\MOD\\Lblapp1A.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"LABELS ROM");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"William Doug Wilder");
  strcpy(ModHeader.Copyright,"Copyright 2008 W. D. Wilder, STC, Sylmar CA");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\LBL1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"LBL1A");
  strcpy(ModPage.ID,"LA1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MLDL OS */
  ModFile=fopen("..\\MOD\\Mldlos.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"MLDL OS");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MLDLOS1A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MLDLOS1A");
  strcpy(ModPage.ID,"OS1A");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MCTEST */
  ModFile=fopen("..\\MOD\\Mctest.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"MCTEST");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MCTEST.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MCTEST");
  strcpy(ModPage.ID,"MCTT");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MDP1 */
  ModFile=fopen("..\\MOD\\Mdp1.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"MDP1");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MDP1L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MDP1L");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\MDP1U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MDP1U");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MDP2 */
  ModFile=fopen("..\\MOD\\Mdp2.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"MDP2");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MDP2L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MDP2L");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\MDP2U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MDP2U");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MELBOURNE ROM */
  ModFile=fopen("..\\MOD\\Melbourne.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Melbourne ROM");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MELBOURNE.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MELBOURNE");
  strcpy(ModPage.ID,"PPC1");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MILITARY ENGINEERING */
  ModFile=fopen("..\\MOD\\Mil-eng.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Military Engineering");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Mil-EngL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Mil-EngL");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Mil-EngU.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Mil-EngU");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MLEPROM */
  ModFile=fopen("..\\MOD\\Mleprom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"MLEPROM");
  strcpy(ModHeader.Version,"1H");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Stephane Barizien");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MLEPROM.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ML EPROM");
  strcpy(ModPage.ID,"ML1H");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MMEPROM */
  ModFile=fopen("..\\MOD\\Mmeprom.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"MM EPROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MMEPROM.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MMEPROM");
  strcpy(ModPage.ID,"MM1E:");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* MUECKE */
  ModFile=fopen("..\\MOD\\Muecke.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"Mcke Structural Module");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Mcke Software");
  strcpy(ModHeader.Copyright,"1982 Mcke Software");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\MUECKEL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MUECKEL");
  strcpy(ModPage.ID,"A   ");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\MUECKEU.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"MUECKEU");
  strcpy(ModPage.ID,"B   ");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* NAVCOM */
  /*   Applied Programming Systems 7461 Pollock Drive Las Vegas, NV 89123. */
  ModFile=fopen("..\\MOD\\Navcom2.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"NAVCOM 2");
  strcpy(ModHeader.Version,"1A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Applied Programming Systems");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\NAVCOM2L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NAVCOM2L");
  strcpy(ModPage.ID,"N21A");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\NAVCOM2U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NAVCOM2U");
  strcpy(ModPage.ID,"N22A");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* NavPac */
  ModFile=fopen("..\\MOD\\Navpac2.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"NAVPAC2");
  strcpy(ModHeader.Version,"2A");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Zengrange");
  strcpy(ModHeader.Copyright,"Copyright Zengrange Defence Systems, Ltd, UK.");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\NAVPAC2L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NAVPAC2L");
  strcpy(ModPage.ID,"NA2A");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\NAVPAC2U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"BW1A");
  strcpy(ModPage.ID,"");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* NEXT */
  ModFile=fopen("..\\MOD\\Next.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"NEXT ROM");
  strcpy(ModHeader.Version,"2B");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Sebastian Toelg");
  strcpy(ModHeader.Copyright,"2013 Sebastian Toelg");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\NEXT2B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"NEXT2B");
  strcpy(ModPage.ID,"NX2B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* PPC/MELBOURNE ROM */
  ModFile=fopen("..\\MOD\\Ppc-melb.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"PPC/MELBOURNE ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PPC-MELB.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PPC-MELB");
  strcpy(ModPage.ID,"PR2C");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* PS0F */
  ModFile=fopen("..\\MOD\\PS0F.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"PS0F NEU");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PS0F.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PS0F");
  strcpy(ModPage.ID,"PS0F:");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ROAM-0 ROM */
  ModFile=fopen("..\\MOD\\ROAM-0.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ROAM-0 ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ROAM-0.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ROAM-0");
  strcpy(ModPage.ID,"0000");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ROAM-0A ROM */
  ModFile=fopen("..\\MOD\\ROAM-0A.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ROAM-0A ROM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ROAM-0A.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ROAM-0A");
  strcpy(ModPage.ID,"0005");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* ROM SV 01 */
  ModFile=fopen("..\\MOD\\ROMSV01.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"ROMSV01");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Serge Vaudenay");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\ROMSV01.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"ROMSV01");
  strcpy(ModPage.ID,"CV01:");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* PCCOM utility programs */
  ModFile=fopen("..\\MOD\\PCCOM.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"PCCOM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Warren Furlow");
  strcpy(ModHeader.Copyright,"Public Domain");
  strcpy(ModHeader.License,"Public Domain");
  strcpy(ModHeader.Comments,"Contains only ROMIN/ROMOUT programs for transfer ROM files over HP-IL");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PCCOM.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PCCOM");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* PRIDE */
  ModFile=fopen("..\\MOD\\Pride.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"PRIDE");
  strcpy(ModHeader.Version,"1");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\PRIDE1.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PRIDE1");
  strcpy(ModPage.ID,"PRDE");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\PRIDE2.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"PRIDE2");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SENDPGM */
  ModFile=fopen("..\\MOD\\Sendpgm.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"SENDPGM");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\SENDPGM.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"SENDPGM");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* SIM */
  ModFile=fopen("..\\MOD\\Sim.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"SURV");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=4;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\Sim12L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Sim12L");
  strcpy(ModPage.ID,"SURV");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Sim12U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Sim12U");
  strcpy(ModPage.ID,"SURV");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Sim34L.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Sim34L");
  strcpy(ModPage.ID,"SURV");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=2;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\Sim34U.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"Sim34U");
  strcpy(ModPage.ID,"SURV");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=2;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* USPS */
  ModFile=fopen("..\\MOD\\Usps.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"US Postal Service");
  strcpy(ModHeader.Version,"");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"");
  strcpy(ModHeader.Copyright,"");
  strcpy(ModHeader.License,"");
  strcpy(ModHeader.Comments,"");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=2;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\USPSL.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"USPSL");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_LOWER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  ROM=read_rom_file("..\\rom\\USPSU.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"USPSU");
  strcpy(ModPage.ID,"@@@@");
  ModPage.Page=POSITION_UPPER;
  ModPage.PageGroup=1;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  /* XFMHEP */
  ModFile=fopen("..\\MOD\\Xfmhep.mod","wb");
  memset(&ModHeader,0,sizeof(ModHeader));
  strcpy(ModHeader.FileFormat,MOD_FORMAT);
  strcpy(ModHeader.Title,"XFMHEP ROM");
  strcpy(ModHeader.Version,"1B");
  strcpy(ModHeader.PartNumber,"");
  strcpy(ModHeader.Author,"Sebastian Toelg");
  strcpy(ModHeader.Copyright,"2013 Sebastian Toelg");
  strcpy(ModHeader.License,"GNU General Public License");
  strcpy(ModHeader.Comments,"For 1:1 emulation of Extended Functions/Memory Module plus most CX functions by means of HEPAX ROM and RAM.  Do not use with real XFM module.");
  ModHeader.Category=CATEGORY_CUSTOM_PERPH;
  ModHeader.Hardware=HARDWARE_NONE;
  ModHeader.MemModules=0;
  ModHeader.XMemModules=0;
  ModHeader.Original=1;
  ModHeader.AppAutoUpdate=0;
  ModHeader.NumPages=1;
  fwrite(&ModHeader,sizeof(ModHeader),1,ModFile);

  ROM=read_rom_file("..\\rom\\XFMHEP1B.rom");
  memset(&ModPage,0,sizeof(ModPage));
  strcpy(ModPage.Name,"XFMHEP1B");
  strcpy(ModPage.ID,"XH1B");
  ModPage.Page=POSITION_ANY;
  ModPage.PageGroup=0;
  ModPage.Bank=1;
  ModPage.BankGroup=0;
  ModPage.RAM=0;
  ModPage.FAT=1;
  pack_image(ROM,ModPage.Image);
  free(ROM);
  fwrite(&ModPage,sizeof(ModPage),1,ModFile);

  fclose(ModFile);

  }
