; Script generated by the HM NIS Edit Script Wizard.

!define VER_MAJOR 9
!define VER_MINOR 14
!define VER_REVISION 0
!define VER_BUILD 0

!define VER_PRG     "9N"
!define VER_FILE    "R${VER_PRG}"
!define VER_DISPLAY "Release ${VER_PRG}"

; Program source path
!define SRC_PATH "..\V41"

; create x86/x64 archive
;!define x86x64

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "V41"
!define PRODUCT_VERSION "${VER_DISPLAY}"
!define PRODUCT_ROOT_FOLDER "HP-Emulators"
!define PRODUCT_COMPANY_NAME "Warren Furlow"
!define PRODUCT_WEB_SITE "http://www.hp41.org/"
;!define PRODUCT_COMPANY_NAME "Christoph Gieelink"
;!define PRODUCT_WEB_SITE "https://hp.giesselink.com/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PRODUCT_NAME}.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "StartMenuDir"
!define MEMENTO_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MEMENTO_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"

!if ${NSIS_PACKEDVERSION} ; NSIS v3.x
  Unicode false           ; since v3.07 default is true
!endif

SetCompressor /FINAL /SOLID lzma

Name "${PRODUCT_NAME}"
Caption "${PRODUCT_NAME} ${VER_DISPLAY} Setup"
OutFile "${PRODUCT_NAME}${VER_FILE}.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_ROOT_FOLDER}\${PRODUCT_NAME}"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
RequestExecutionLevel admin
BrandingText "${PRODUCT_COMPANY_NAME}"
;ShowInstDetails show
;ShowUnInstDetails show
CRCCheck force

; installation file properties
VIProductVersion "${VER_MAJOR}.${VER_MINOR}.${VER_REVISION}.${VER_BUILD}"
VIAddVersionKey "CompanyName" "${PRODUCT_COMPANY_NAME}"
VIAddVersionKey "FileDescription" "V41 Calculator Emulator Installation"
VIAddVersionKey "FileVersion" "${VER_MAJOR}, ${VER_MINOR}, ${VER_REVISION}, ${VER_BUILD}"
VIAddVersionKey "LegalCopyright" "Copyright  2025"
VIAddVersionKey "OriginalFilename" "${PRODUCT_NAME}${PRODUCT_VERSION}.exe"
VIAddVersionKey "ProductName" "${PRODUCT_NAME} ${PRODUCT_VERSION}"
VIAddVersionKey "ProductVersion" "${VER_MAJOR}, ${VER_MINOR}, ${VER_REVISION}, ${VER_BUILD}"

; MUI 2.0 compatible ------
!include "MUI2.nsh"
!include "Memento.nsh"
!include "LogicLib.nsh"
!include "WordFunc.nsh"
!include "FileFunc.nsh"
!include "WinVer.nsh"
!include "x64.nsh"
!InsertMacro GetParent
!insertmacro un.GetParent
!insertmacro VersionCompare

; Plugins directory
!if ${NSIS_PACKEDVERSION} ; NSIS v3.x
  !if ${NSIS_CHAR_SIZE} == 1
    !define PLUGINSDIR "${NSISDIR}\Plugins\x86-ansi"
  !else
    !define PLUGINSDIR "${NSISDIR}\Plugins\x86-unicode"
  !endif
!else ; NSIS v2.x
  !define PLUGINSDIR "${NSISDIR}\Plugins"
!endif

; MUI Settings
!define MUI_ABORTWARNING
;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install-blue.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall-blue.ico"
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\pixel-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\pixel-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME

; License page
!define MUI_LICENSEPAGE_TEXT_BOTTOM "$(^Name) is released under the GNU General Public License (GPL). The license is provided here for information purposes only. $_CLICK"
!define MUI_LICENSEPAGE_BUTTON "$(^NextBtn)"
!insertmacro MUI_PAGE_LICENSE "${SRC_PATH}\License.txt"

; Directory page
!insertmacro MUI_PAGE_DIRECTORY

; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "${PRODUCT_NAME}"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
;!define MUI_FINISHPAGE_RUN "$INSTDIR\${PRODUCT_NAME}.exe"
;!define MUI_FINISHPAGE_RUN_NOTCHECKED
!define MUI_FINISHPAGE_NOREBOOTSUPPORT
!define MUI_FINISHPAGE_LINK "Visit the Emulator site for the latest news."
!define MUI_FINISHPAGE_LINK_LOCATION "${PRODUCT_WEB_SITE}"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
ReserveFile "${PLUGINSDIR}\UserInfo.dll"
ReserveFile "${PLUGINSDIR}\AccessControl.dll"

; MUI end ------

Var AccountType

${MementoSection} "Program Files" SecMain
  SetDetailsPrint textonly
  DetailPrint "Installing V41 Emulator Files..."
  SetDetailsPrint listonly

  SetOutPath "$INSTDIR"
  SetOverwrite On

  !ifdef x86x64
  ${If} ${RunningX64}
    File "${SRC_PATH}\x64\V41.exe"
  ${Else}
    File "${SRC_PATH}\x86\V41.exe"
  ${EndIf}
  !else
  File "${SRC_PATH}\V41.exe"
  !endif
  File "${SRC_PATH}\Help.txt"
  File "${SRC_PATH}\Index.txt"
  File "${SRC_PATH}\License.txt"
  File "${SRC_PATH}\LCD.fon"
  File "${SRC_PATH}\LCD4.ttf"
  File "${SRC_PATH}\XLarge.bmp"
  File "${SRC_PATH}\Large.bmp"
  File "${SRC_PATH}\Medium.bmp"
  File "${SRC_PATH}\Small.bmp"
  File "${SRC_PATH}\Tiny.bmp"
  File "${SRC_PATH}\Back.bmp"

  SetOverwrite ifnewer
  File "${SRC_PATH}\HP-41C.lod"
  File "${SRC_PATH}\HP-41CV.lod"
  File "${SRC_PATH}\HP-41CX.lod"

  SetOutPath "$INSTDIR\MOD"
  SetOverwrite ifnewer
  File /r "${SRC_PATH}\MOD\*.*"

  SetOutPath "$INSTDIR\RAW"
  SetOverwrite on
  File /r "${SRC_PATH}\RAW\*.*"

  ${If} $AccountType == "Admin"
    ; make the directory "$INSTDIR" full accessible by all users (need for adding and modifying MOD and RAW files
    AccessControl::GrantOnFile "$INSTDIR" "(S-1-5-32-545)" "FullAccess"
  ${EndIf}

; File association
  WriteRegStr HKCR ".lod" "" "${PRODUCT_NAME}.Session"
  WriteRegStr HKCR "${PRODUCT_NAME}.Session" "" "${PRODUCT_NAME} Emulator File"
  WriteRegStr HKCR "${PRODUCT_NAME}.Session\DefaultIcon" "" "$INSTDIR\${PRODUCT_NAME}.exe,0"
  WriteRegStr HKCR "${PRODUCT_NAME}.Session\shell" "" "open"
  WriteRegStr HKCR "${PRODUCT_NAME}.Session\shell\open\command" "" '"$INSTDIR\${PRODUCT_NAME}.exe" "%1"'
  ${RefreshShellIcons}

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\V41.lnk" "$INSTDIR\V41.exe"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\V41 Help.lnk" "$INSTDIR\Help.txt"
  CreateShortCut "$DESKTOP\V41.lnk" "$INSTDIR\V41.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
${MementoSectionEnd}

Section -AdditionalIcons
  SetDetailsPrint textonly
  DetailPrint "Creating Shortcuts..."
  SetDetailsPrint listonly

  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr   HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr   ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name) ${PRODUCT_VERSION}"
  WriteRegStr   ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr   ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr   ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr   ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegDword ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionMajor" "${VER_MAJOR}"
  WriteRegDword ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionMinor" "${VER_MINOR}"
  WriteRegDword ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionRevision" "${VER_REVISION}"
  WriteRegDword ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionBuild" "${VER_BUILD}"

  ${MementoSectionSave}
SectionEnd

${MementoSectionDone}

Function .onInit
  !ifdef x86x64
  ${If} ${RunningX64}
    DetailPrint "Installer running on 64-bit host"
    ; change install dir
    StrCpy $INSTDIR "$PROGRAMFILES64\${PRODUCT_ROOT_FOLDER}\${PRODUCT_NAME}"
  ${EndIf}
  !endif

  UserInfo::GetAccountType                  ; get account type
  Pop $AccountType
  ${If} $AccountType == "Admin"
    SetShellVarContext all                  ; write links to all users
  ${EndIf}

  ${MementoSectionRestore}
FunctionEnd

Section Uninstall
  !ifdef x86x64
  ${If} ${RunningX64}
    DetailPrint "Uninstaller running on 64-bit host"
    ; change install dir
    StrCpy $INSTDIR "$PROGRAMFILES64\${PRODUCT_ROOT_FOLDER}\${PRODUCT_NAME}"
  ${EndIf}
  !endif

  UserInfo::GetAccountType                  ; get account type
  Pop $R0
  ${If} $R0 == "Admin"
    SetShellVarContext all                  ; write links to all users
  ${EndIf}

  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP

  SetDetailsPrint textonly
  DetailPrint "Deleting Files..."
  SetDetailsPrint listonly

  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"

; section Program Files
  Delete "$INSTDIR\V41.exe"
  Delete "$INSTDIR\Help.txt"
  Delete "$INSTDIR\Index.txt"
  Delete "$INSTDIR\License.txt"
  Delete "$INSTDIR\LCD.fon"
  Delete "$INSTDIR\LCD4.ttf"
  Delete "$INSTDIR\XLarge.bmp"
  Delete "$INSTDIR\Large.bmp"
  Delete "$INSTDIR\Medium.bmp"
  Delete "$INSTDIR\Small.bmp"
  Delete "$INSTDIR\Tiny.bmp"
  Delete "$INSTDIR\Back.bmp"
  Delete "$INSTDIR\HP-41C.lod"
  Delete "$INSTDIR\HP-41CV.lod"
  Delete "$INSTDIR\HP-41CX.lod"

  RMDir /r "$INSTDIR\MOD"
  Sleep 10 ; workaround for locked directory

  RMDir /r "$INSTDIR\RAW"
  Sleep 10 ; workaround for locked directory

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\V41.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\V41 Help.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$DESKTOP\V41.lnk"

; delete ${PRODUCT_NAME}
  RMDir "$SMPROGRAMS\$ICONS_GROUP"

  RMDir "$INSTDIR"
  Sleep 10 ; workaround for locked directory
; try to delete parent of install dir (normally ${PRODUCT_ROOT_FOLDER})
  ${un.GetParent} $INSTDIR $R0
  RMDir "$R0"

  SetDetailsPrint textonly
  DetailPrint "Deleting Registry Keys..."
  SetDetailsPrint listonly

; File association
  !macro DelFileAssocation Ext
    ReadRegStr $R0 HKCR "${Ext}" ""
    ${If} $R0 == "${PRODUCT_NAME}.Session"
      DeleteRegKey HKCR "${Ext}"
    ${EndIf}
  !macroend

  !insertmacro DelFileAssocation ".lod"
  DeleteRegKey HKCR "${PRODUCT_NAME}.Session"
  ${RefreshShellIcons}

; Application specific cleanup
  DeleteRegKey HKCU "Software\V41"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd